/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images;

import com.andavin.images.PacketListener;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

class ProtocolLibListener<T, U>
extends PacketAdapter {
    private final PacketListener.ImageListener listener;
    private final PacketListener packetListener;

    ProtocolLibListener(Plugin plugin, PacketListener.ImageListener listener, PacketListener packetListener) {
        super(plugin, new PacketType[]{PacketType.Play.Client.USE_ENTITY, PacketType.Play.Client.SET_CREATIVE_SLOT});
        this.listener = listener;
        this.packetListener = packetListener;
    }

    public void onPacketReceiving(PacketEvent event) {
        PacketType type = event.getPacketType();
        if (type == PacketType.Play.Client.USE_ENTITY) {
            this.packetListener.handle(event.getPlayer(), this.listener, event.getPacket().getHandle());
        } else if (type == PacketType.Play.Client.SET_CREATIVE_SLOT) {
            this.packetListener.handle(event.getPlayer(), event.getPacket().getHandle());
        }
    }

    static void register(Plugin plugin, Map<UUID, PacketListener.ImageListener> listenerTasks, PacketListener bridge) {
        ProtocolLibrary.getProtocolManager().addPacketListener(new ProtocolLibListener(plugin, (clicker, image, section, action, hand) -> {
            PacketListener.ImageListener listener = (PacketListener.ImageListener)listenerTasks.remove(clicker.getUniqueId());
            if (listener != null) {
                listener.click(clicker, image, section, action, hand);
            }
        }, bridge));
    }
}

